#pragma once
#include <vector>
#include <cassert>

struct Graph {
    struct Edge {
        int to;
        int id;
    };

    int n;
    std::vector<std::vector<Edge>> adj;
    std::vector<std::pair<int, int>> edges;

    Graph(int vertices = 0) {
        n = vertices;
        adj = std::vector<std::vector<Edge>>(vertices);
    }

    int add_edge(int u, int v) {
        assert(0 <= u && u < n);
        assert(0 <= v && v < n);
        int id = edges.size();
        edges.emplace_back(u, v);
        adj[u].push_back({ v, id });
        adj[v].push_back({ u, id });
        return id;
    }

    // builders:
    static Graph cycle(int n) {
        Graph g(n);
        for (int i = 0; i < n; ++i)
            g.add_edge(i, (i + 1) % n);
        return g;
    }

    static Graph path(int n) {
        Graph g(n);
        for (int i = 0; i + 1 < n; ++i)
            g.add_edge(i, i + 1);
        return g;
    }

    static Graph complete(int n) {
        Graph g(n);
        for (int i = 0; i < n; ++i)
            for (int j = i + 1; j < n; ++j)
                g.add_edge(i, j);
        return g;
    }
};